<?php
error_reporting(0);
define('ROOT', dirname(__DIR__) . DIRECTORY_SEPARATOR . 'mvc_painel' . DIRECTORY_SEPARATOR);
define('APP', ROOT . 'application' . DIRECTORY_SEPARATOR);
date_default_timezone_set("America/Sao_Paulo");
setlocale(LC_ALL, 'pt_BR');

require ROOT . 'vendor/autoload.php';
require ROOT . 'application/libs/Helper.php';
require ROOT . 'application/libs/Upload.php';
require ROOT . 'application/view/fragments/loja.php';
require APP . 'config/config.php';

$url = \AgendaLabs\Libs\Helper::splitUrl();

session_cache_expire(605400);
@session_cache_limiter('nocache');
session_start();

use AgendaLabs\Core\Route;

$Route = new Route($url);

// SITE
$Route->get('appwebview', 'SiteController@index');
$Route->get('cidades', 'SiteController@cidade', 'id_cidade');
$Route->get('segmentos', 'SiteController@segmentos');
$Route->get('categorias', 'SiteController@categorias');
$Route->get('pedidosonline', 'SiteController@pedidosOnline');
$Route->post('pesquisa', 'SiteController@pesquisa');
$Route->get('estabelecimentos', 'SiteController@estabelecimentos', 'id_segmento');
$Route->get('estabelecimento', 'SiteController@estabelecimento', 'id_loja');
$Route->get('promocoes', 'SiteController@promocoes');
$Route->get('destaques', 'SiteController@destaques');
$Route->get('cardapios', 'SiteController@cardapios', 'id_loja');
$Route->get('favoritos', 'SiteController@favoritos');
$Route->get('addfavoritos', 'SiteController@addFavoritos', 'id_loja');
$Route->get('removefavoritos', 'SiteController@removeFavoritos', 'id_loja');
$Route->view('anuncie', 'site/home/anuncie');
$Route->view('faleconosco', 'site/home/faleconosco');
$Route->get('filtros', 'SiteController@filtros');
$Route->post('filtrar', 'SiteController@filtrar');
$Route->get('listarfiltros', 'SiteController@listarfiltros');
$Route->get('temp', 'SiteController@temp');

$Route->get('checkout', 'SiteController@checkout');
$Route->get('checkoutentrega', 'SiteController@checkoutentrega');
$Route->post('finalizarpedido', 'SiteController@finalizarpedido');

$Route->get('meuspedidos', 'SiteController@meuspedidos');
$Route->post('avaliacao', 'SiteController@avaliacao');

$Route->get('delivery', 'SiteController@delivery');

$Route->post('cliente', 'ClienteController@update');

// ADMIN
$Route->get('login', 'AuthController@loginScreen');
$Route->post('login', 'AuthController@login');
$Route->get('logout', 'AuthController@logout');

$Route->view('forgot', 'admin/auth/forgot');
$Route->post('forgot', 'AuthController@forgot');
$Route->get('remember', 'AuthController@remember', 'session');
$Route->post('newpassword', 'AuthController@newpassword');

// TODO: ############
$Route->group2('ajax', function () {
    \AgendaLabs\Libs\Helper::ajax($_POST['controller'], $_POST['action'], $_POST['param']);
    exit();
});

if (@$_SESSION['acesso'] == 'Administrador') {
}

if (@$_SESSION['acesso'] == 'Administrador' || @$_SESSION['acesso'] == 'Empresa') {
    $Route->group('system', function ($Route) {
        if (@$_SESSION['acesso'] == 'Administrador') {
            $Route->group('loja', function ($Route) {
                $Route->crud('loja');
                $Route->get('deliverystatus', 'LojaController@deliverystatus', 'id_loja,delivery_status');
            });
            $Route->group('usuario', function ($Route) {
                $Route->crud('user');
            });
            $Route->group('tamanho', function ($Route) {
                $Route->crud('tamanho');
            });
            $Route->group('novidade', function ($Route) {
                $Route->crud('novidade');
            });
        }

        //permissoes para Empresa
        if (@$_SESSION['acesso'] == 'Empresa') {
            $Route->group('loja', function ($Route) {
                $Route->get('', 'LojaController@index');
                $Route->get('editar', 'LojaController@viewEdit', 'id');
                $Route->post('salvar', 'LojaController@update');
                $Route->get('deliverystatus', 'LojaController@deliverystatus', 'id_loja,delivery_status');
            });
        }

        $Route->group('realtime', function ($Route) {
            $Route->get('', 'RealtimeController@index');
            $Route->post('auth', 'RealtimeController@auth');
        });

        $Route->group('account', function ($Route) {
            $Route->get('', 'AuthController@account');
            $Route->post('save', 'AuthController@update');
        });

        $Route->get('', 'HomeController@admin');

        $Route->get('forbidden', 'HomeController@forbidden');

        $Route->group('categoria', function ($Route) {
            $Route->crud('categoria');
            $Route->get('order', 'CategoriaController@changeCategoryOrder', 'id,order');
            $Route->get('status', 'CategoriaController@changeCategoryStatus', 'id_categoria,acao');
        });
        $Route->group('subcategoria', function ($Route) {
            $Route->crud('subcategoria');
        });
        $Route->group('produto', function ($Route) {
            $Route->crud('produto');
        });

        $Route->group('produto_valor', function ($Route) {
            $Route->post('cadastrar', 'ProdutoValorController@create');
            $Route->get('remover', 'ProdutoValorController@delete');
        });

        $Route->group('loja_parte', function ($Route) {
            $Route->post('salvar', 'LojaParteController@createOrUpdate');
        });

        $Route->group('adicional', function ($Route) {
            $Route->crud('adicional');
        });

        $Route->group('pedido', function ($Route) {
            $Route->get('', 'PedidoController@index');
            $Route->post('', 'PedidoController@index');
            $Route->get('painel', 'PedidoController@painel');
            $Route->get('painel2', 'PedidoController@painel2');
            $Route->get('situacao', 'PedidoController@situacao', 'id,situacao');
            $Route->get('frame', 'PedidoController@pedidoframe');
            $Route->get('framekanban', 'PedidoController@pedidoframekanban');
            $Route->get('sinal', 'PedidoController@sinal');
            $Route->get('recibo', 'PedidoController@recibo', 'id');
        });

        $Route->group('caixa', function ($Route) {
            $Route->crud('caixa');
        });

        $Route->get('venda', 'PedidoController@venda');
        $Route->post('venda', 'PedidoController@create');
        $Route->get('cupom', 'PedidoController@cupom', 'id_pedido');

        $Route->get('lancar', 'PedidoController@venda', 'acao,id');
        $Route->get('mesa', 'PedidoController@mesa');
        $Route->post('mesa', 'PedidoController@mesaCreate');

        $Route->group2('cozinha', function ($Route) {
            $Route->get('pedidos', 'CozinhaController@index');
            $Route->get('pronto/{id}', 'CozinhaController@pronto');
        });

        $Route->group('reportar', function ($Route) {
            $Route->crud('reportar');
        });

        $Route->group('cidade', function ($Route) {
            $Route->crud('cidade');
        });

        $Route->group('formapagamento', function ($Route) {
            $Route->crud('formapagamento');
        });

        $Route->group('facilidade', function ($Route) {
            $Route->crud('facilidade');
        });

        $Route->group('segmento', function ($Route) {
            $Route->crud('segmento');
        });

        $Route->group('cardapio', function ($Route) {
            $Route->crud('cardapio');
        });

        $Route->group('promocao', function ($Route) {
            $Route->crud('promocao');
        });

        $Route->group('destaque', function ($Route) {
            $Route->crud('destaque');
        });
    });
} else {
    header('location: ' . URL_PUBLIC . '/segmentos');
}
