<?php

namespace AgendaLabs\Controller;

use AgendaLabs\Libs\Helper;
use AgendaLabs\Model\Promocao;

class PromocaoController
{

    private $table    = 'promocao';
    private $baseView = 'admin/promocao';
    private $urlIndex = 'promocao';

    public function index()
    {
        $model    = new Promocao();
        $response = $model->allPromocao();
        Helper::view($this->baseView . '/index', $response);
    }

    public function viewNew()
    {
        $model             = new Promocao();
        $response['lojas'] = $model->all('loja', 'nome DESC');
        Helper::view($this->baseView . '/edit', $response);
    }

    public function viewEdit($param)
    {
        $model             = new Promocao();
        $response          = $model->find($this->table, $param['id']);
        $response['lojas'] = $model->all('loja', 'nome DESC');
        Helper::view($this->baseView . '/edit', $response);
    }

    public function create()
    {
        $model = new Promocao();
        if (empty($_POST['agendamento']) || $_POST['agendamento'] == "31/12/1969") :
            $_POST['agendamento'] = "2019-01-01";
        else :
            $_POST['agendamento'] = Helper::data($_POST['agendamento'], 1);
        endif;
        if (empty($_POST['validade']) || $_POST['validade'] == "31/12/1969") :
            $_POST['validade'] = "2999-12-31";
        else :
            $_POST['validade'] = Helper::data($_POST['validade'], 1);
        endif;
        if (!empty($_POST['validade'])) :
            $_POST['data_inicio'] = Helper::data($_POST['data_inicio'], 1);
        endif;
        $_POST['data_fim'] = Helper::data($_POST['data_fim'], 1);
        $id                = $model->create($this->table, $_POST, ['id', 'image']);
        if ($id) {
            $caminho          = 'files/promocao/';
            $nome_imagem      = $id . '_' . time();
            $nome_imagem_capa = $id . '_capa_' . time();
            $formato          = 'jpg';
            if (Helper::upload($_FILES['imagem_capa'], $nome_imagem_capa, $caminho, $formato, 360, 360)) {
                $model->save($this->table, ['id' => $id, 'imagem_capa' => $caminho . $nome_imagem_capa . '.' . $formato]);
            }
            if (Helper::upload($_FILES['imagem'], $nome_imagem, $caminho, $formato, 800, 800)) {
                $model->save($this->table, ['id' => $id, 'imagem' => $caminho . $nome_imagem . '.' . $formato]);
            }
            header('location: ' . URL_ADMIN . '/' . $this->urlIndex . '?msg=1');
        } else {
            Helper::view($this->baseView . '/edit', $_POST);
        }
    }

    public function update()
    {
        $model = new Promocao();
        if (empty($_POST['agendamento']) || $_POST['agendamento'] == "31/12/1969") :
            $_POST['agendamento'] = "2019-01-01";
        else :
            $_POST['agendamento'] = Helper::data($_POST['agendamento'], 1);
        endif;
        if (empty($_POST['validade']) || $_POST['validade'] == "31/12/1969") :
            $_POST['validade'] = "2999-12-31";
        else :
            $_POST['validade'] = Helper::data($_POST['validade'], 1);
        endif;
        if (!empty($_POST['data_inicio'])) :
            $_POST['data_inicio'] = Helper::data($_POST['data_inicio'], 1);
        endif;
        $_POST['data_fim'] = Helper::data($_POST['data_fim'], 1);
        if ($model->save($this->table, $_POST, ['image'])) {
            $id               = $_POST['id'];
            $caminho          = 'files/promocao/';
            $nome_imagem      = $id . '_' . time();
            $nome_imagem_capa = $id . '_capa_' . time();
            $formato          = 'jpg';
            if (Helper::upload($_FILES['imagem_capa'], $nome_imagem_capa, $caminho, $formato, 360, 360)) {
                $model->save($this->table, ['id' => $id, 'imagem_capa' => $caminho . $nome_imagem_capa . '.' . $formato]);
            }
            if (Helper::upload($_FILES['imagem'], $nome_imagem, $caminho, $formato, 800, 800)) {
                $model->save($this->table, ['id' => $id, 'imagem' => $caminho . $nome_imagem . '.' . $formato]);
            }
            header('location: ' . URL_ADMIN . '/' . $this->urlIndex . '?msg=1');
        } else {
            Helper::view($this->baseView . '/edit/' . $_POST['id']);
        }
    }

    public function delete($param)
    {
        $model = new Promocao();
        $model->delete($this->table, 'id', $param['id']);
        header('location: ' . URL_ADMIN . '/' . $this->urlIndex);
    }

    public function ordem($param)
    {
        $model = new Promocao();
        $model->defineOrder($this->table, $param['id'], $param['ordem']);
        header('location: ' . URL_ADMIN . '/' . $this->urlIndex);
    }
}
